<?php
require_once 'config.php';
require_admin();

$message = '';

// --- CRUD Operations ---
if (isset($_POST['add_notice'])) {
    $title = trim($_POST['title']);
    $description = trim($_POST['description']);
    $image_url = null; // Optional image

    // Image upload logic
    if (!empty($_FILES['image']['name']) && $_FILES['image']['error'] == UPLOAD_ERR_OK) {
        $uploadDir = 'uploads/notices/';
        if (!is_dir($uploadDir)) { mkdir($uploadDir, 0777, true); }
        $fileName = uniqid('notice_') . '_' . basename($_FILES['image']['name']);
        $targetPath = $uploadDir . $fileName;
        if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
            $image_url = $targetPath;
        } else {
            $message = 'Warning: Failed to upload notice image.';
        }
    }

    try {
        $stmt = $pdo->prepare("INSERT INTO notices (title, description, image_url) VALUES (?, ?, ?)");
        $stmt->execute([$title, $description, $image_url]);
        $message = 'Notice posted successfully!';
    } catch (PDOException $e) {
        $message = 'Error posting notice: ' . $e->getMessage();
    }
}

// Fetch all notices for management view
$stmt = $pdo->query("SELECT id, title, created_at FROM notices ORDER BY created_at DESC");
$notices = $stmt->fetchAll();

require_once 'layouts.php';
render_header('Add Notice');
render_sidebar($_SESSION['user_role'], basename(__FILE__));
render_topbar('Manage Notices');
?>

<div class="space-y-8">
    <?php if ($message): ?>
        <div class="bg-indigo-100 border-l-4 border-indigo-500 text-indigo-700 p-4 mb-6 rounded-lg" role="alert"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <!-- Add New Notice Form -->
    <div class="bg-white p-6 rounded-xl shadow-lg">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">Post New Announcement</h2>
        <form method="POST" action="addnotice.php" enctype="multipart/form-data" class="space-y-4">
            <div>
                <label for="title" class="block text-sm font-medium text-gray-700">Title</label>
                <input type="text" name="title" id="title" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg">
            </div>
            <div>
                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                <textarea name="description" id="description" rows="5" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg"></textarea>
            </div>
            <div>
                <label for="image" class="block text-sm font-medium text-gray-700">Image (Optional)</label>
                <input type="file" name="image" id="image" accept="image/*" class="mt-1 block w-full text-sm text-gray-900 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
            </div>
            <button type="submit" name="add_notice" class="w-48 py-3 bg-green-600 text-white rounded-lg hover:bg-green-700 font-semibold transition duration-150 shadow-md">
                Post Notice
            </button>
        </form>
    </div>

    <!-- Existing Notices List -->
    <h2 class="text-2xl font-bold text-gray-900 pt-4 border-t mt-8">Existing Notices</h2>
    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
        <ul class="divide-y divide-gray-200">
            <?php if ($notices): ?>
                <?php foreach ($notices as $notice): ?>
                    <li class="p-4 hover:bg-gray-50 flex justify-between items-center">
                        <div>
                            <p class="text-lg font-medium text-gray-900"><?php echo htmlspecialchars($notice['title']); ?></p>
                            <span class="text-sm text-gray-500">Posted on: <?php echo date('M d, Y', strtotime($notice['created_at'])); ?></span>
                        </div>
                        <!-- Actions (Edit/Delete - Omitted for brevity, but this is where they would go) -->
                        <div class="text-sm text-indigo-600">
                            <!-- <i class="fa-solid fa-edit mr-3"></i> -->
                            <!-- <i class="fa-solid fa-trash text-red-500"></i> -->
                        </div>
                    </li>
                <?php endforeach; ?>
            <?php else: ?>
                <li class="p-4 text-gray-500">No notices have been posted yet.</li>
            <?php endif; ?>
        </ul>
    </div>
</div>

<?php render_main_content_end(); ?>