<?php
require_once 'config.php';

$message = $_GET['msg'] ?? '';

// Handle Logout
if (isset($_GET['logout'])) {
    session_destroy();
    session_start();
    $message = 'You have been successfully logged out.';
}

// Handle Login (No Change)
if (isset($_POST['login'])) {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        // Successful Login
        $_SESSION['user_id'] = $user['id'];
        // Note: Using 'first_name' and 'last_name' instead of original 'name'
        $_SESSION['user_name'] = $user['first_name'] . ' ' . $user['last_name']; 
        $_SESSION['user_role'] = $user['role'];
        $_SESSION['image_url'] = $user['image_url'];

        // Redirect based on role
        if ($user['role'] === 'admin') {
            header('Location: dashboard.php');
        } else {
            header('Location: studentdash.php');
        }
        exit();
    } else {
        $message = 'Invalid email or password.';
    }
}

// ====================================================================
// --- UPDATED Registration Handler to include ALL new fields ---
// ====================================================================
if (isset($_POST['register'])) {
    // Collect all new fields from the form
    $first_name = trim($_POST['first_name']);
    $last_name = trim($_POST['last_name']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    
    // Personal Information
    $phone_number = trim($_POST['phone_number']);
    $whatsapp_number = trim($_POST['whatsapp_number']);
    $nic_card_number = trim($_POST['nic_card_number']);
    $date_of_birth = trim($_POST['date_of_birth']);
    
    // School Information
    $school_name = trim($_POST['school_name']);
    $exam_year = trim($_POST['exam_year']); // e.g., "2025 O/L"
    $stream = trim($_POST['stream']);       // e.g., "සිංහල"

    // Basic validation: Check if all *required* fields are present
    if (empty($first_name) || empty($last_name) || empty($email) || empty($password) || empty($phone_number) || empty($nic_card_number) || empty($date_of_birth) || empty($school_name) || empty($exam_year) || empty($stream)) {
        // Sinhala message: All fields are required for registration.
        $message = 'සියලුම ක්ෂේත්‍ර (All fields) ලියාපදිංචිය සඳහා අවශ්‍ය වේ.';
    } else {
        try {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            // The INSERT statement must now include all new column names
            $sql = "INSERT INTO users (
                        first_name, last_name, email, password, phone_number, 
                        whatsapp_number, nic_card_number, date_of_birth, 
                        school_name, exam_year, stream, role
                    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'student')";
            
            $stmt = $pdo->prepare($sql);
            
            $stmt->execute([
                $first_name, $last_name, $email, $hashed_password, $phone_number, 
                $whatsapp_number, $nic_card_number, $date_of_birth, 
                $school_name, $exam_year, $stream
            ]);

            // Log registration event
            log_analytics($pdo, 'registration', $pdo->lastInsertId());

            // Sinhala message: Registration successful! Please login.
            $message = 'ලියාපදිංචිය සාර්ථකයි! කරුණාකර ලොග් වන්න. (Registration successful! Please login.)';
        } catch (PDOException $e) {
            if ($e->getCode() === '23000') {
                // Sinhala message: Registration failed: This email is already registered.
                $message = 'ලියාපදිංචිය අසාර්ථකයි: මෙම විද්‍යුත් තැපෑල දැනටමත් ලියාපදිංචි කර ඇත. (Registration failed: This email is already registered.)';
            } else {
                error_log("Registration database error: " . $e->getMessage());
                // Sinhala message: Registration failed due to a database error.
                $message = 'දත්ත සමුදා දෝෂයක් හේතුවෙන් ලියාපදිංචිය අසාර්ථක විය. (Registration failed due to a database error.)';
            }
        }
    }
}

require_once 'layouts.php';
render_header('Login/Register');
?>

<div class="min-h-screen flex items-center justify-center bg-gray-100">
    <script>
        // Toggle between Login and Register forms
        function toggleForm(showForm) {
            document.getElementById('login-form').classList.add('hidden');
            document.getElementById('register-form').classList.add('hidden');
            document.getElementById(showForm + '-form').classList.remove('hidden');
            document.getElementById('login-tab').classList.remove('bg-indigo-600', 'text-white');
            document.getElementById('register-tab').classList.remove('bg-indigo-600', 'text-white');
            document.getElementById(showForm + '-tab').classList.add('bg-indigo-600', 'text-white');
        }
    </script>
    <div class="max-w-xl w-full bg-white p-8 rounded-xl shadow-2xl">
        <h1 class="text-4xl font-extrabold text-center text-gray-900 mb-6"><?php echo APP_NAME; ?></h1>

        <!-- Messages -->
        <?php if ($message): ?>
            <div class="bg-indigo-100 border-l-4 border-indigo-500 text-indigo-700 p-4 mb-4 rounded-lg" role="alert">
                <p><?php echo htmlspecialchars($message); ?></p>
            </div>
        <?php endif; ?>

        <!-- Tabs -->
        <div class="flex mb-6 bg-gray-200 rounded-lg p-1">
            <button id="login-tab" onclick="toggleForm('login')" class="flex-1 py-2 px-4 rounded-lg font-semibold transition duration-150 bg-indigo-600 text-white">Login</button>
            <button id="register-tab" onclick="toggleForm('register')" class="flex-1 py-2 px-4 rounded-lg font-semibold transition duration-150 text-gray-600">Register</button>
        </div>

        <!-- Login Form (No Change) -->
        <form id="login-form" method="POST" action="index.php" class="space-y-6">
            <div>
                <label for="login_email" class="block text-sm font-medium text-gray-700">Email Address</label>
                <input id="login_email" name="email" type="email" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
            </div>
            <div>
                <label for="login_password" class="block text-sm font-medium text-gray-700">Password</label>
                <input id="login_password" name="password" type="password" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
            </div>
            <button type="submit" name="login" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-lg shadow-sm text-lg font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition duration-150">
                Sign in
            </button>
        </form>

        <!-- ==================================================================== -->
        <!-- --- UPDATED Register Form with all new fields --- -->
        <!-- ==================================================================== -->
        <form id="register-form" method="POST" action="index.php" class="space-y-6 hidden">
            
            <div class="space-y-4 p-4 border border-gray-200 rounded-xl shadow-inner bg-gray-50">
                <h2 class="text-xl font-bold text-gray-800 border-b-2 border-indigo-200 pb-2">Personal Information</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <!-- First Name -->
                    <div>
                        <label for="reg_first_name" class="block text-sm font-medium text-gray-700">First Name</label>
                        <input id="reg_first_name" name="first_name" type="text" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Last Name -->
                    <div>
                        <label for="reg_last_name" class="block text-sm font-medium text-gray-700">Last Name</label>
                        <input id="reg_last_name" name="last_name" type="text" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                </div>

                <!-- Email Address -->
                <div>
                    <label for="reg_email" class="block text-sm font-medium text-gray-700">Email Address</label>
                    <input id="reg_email" name="email" type="email" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <!-- Phone Number -->
                    <div>
                        <label for="reg_phone" class="block text-sm font-medium text-gray-700">Phone Number</label>
                        <input id="reg_phone" name="phone_number" type="tel" pattern="[0-9]{10}" title="Ten digits code" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- WhatsApp Number -->
                    <div>
                        <label for="reg_whatsapp" class="block text-sm font-medium text-gray-700">WhatsApp Number (Optional)</label>
                        <input id="reg_whatsapp" name="whatsapp_number" type="tel" class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500" placeholder="Same as phone or leave blank">
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <!-- NIC Card Number -->
                    <div>
                        <label for="reg_nic" class="block text-sm font-medium text-gray-700">NIC Card Number</label>
                        <input id="reg_nic" name="nic_card_number" type="text" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Date of Birth -->
                    <div>
                        <label for="reg_dob" class="block text-sm font-medium text-gray-700">Date of Birth</label>
                        <input id="reg_dob" name="date_of_birth" type="date" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                </div>
            </div>
            
            <div class="space-y-4 p-4 border border-gray-200 rounded-xl shadow-inner bg-gray-50">
                <h2 class="text-xl font-bold text-gray-800 border-b-2 border-indigo-200 pb-2">School Information</h2>
                
                <!-- School Name -->
                <div>
                    <label for="reg_school" class="block text-sm font-medium text-gray-700">School Name</label>
                    <input id="reg_school" name="school_name" type="text" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <!-- Exam Year (O/L or A/L) -->
                    <div>
                        <label for="reg_exam_year" class="block text-sm font-medium text-gray-700">Exam Year (O/L/A/L)</label>
                        <input id="reg_exam_year" name="exam_year" type="text" placeholder="e.g., 2025 O/L" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    <!-- Media/Stream -->
                    <div>
                        <label for="reg_stream" class="block text-sm font-medium text-gray-700">Media/Stream</label>
                        <input id="reg_stream" name="stream" type="text" placeholder="e.g., Science, Arts, සිංහල" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                </div>
            </div>
            
            <!-- Password -->
            <div>
                <label for="reg_password" class="block text-sm font-medium text-gray-700">Password</label>
                <input id="reg_password" name="password" type="password" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
            </div>

            <button type="submit" name="register" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-lg shadow-sm text-lg font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition duration-150">
                Register
            </button>
        </form>
    </div>
</div>

<?php 
// Ensure the form is correctly displayed on page load if there was a registration attempt
if (isset($_POST['register'])) {
    echo '<script>toggleForm("register");</script>';
}
render_footer(); 
?>