<?php
require_once 'config.php';
require_login();

if (is_admin()) {
    header('Location: dashboard.php');
    exit();
}

// Fetch all notices
$stmt = $pdo->prepare("SELECT title, description, image_url, created_at FROM notices ORDER BY created_at DESC");
$stmt->execute();
$notices = $stmt->fetchAll();

require_once 'layouts.php';
render_header('Notices');
render_sidebar($_SESSION['user_role'], basename(__FILE__));
render_topbar('Notices and Announcements');
?>

<div class="space-y-8">
    <?php if ($notices): ?>
        <?php foreach ($notices as $notice): ?>
            <div class="bg-white p-6 rounded-xl shadow-lg">
                <div class="flex justify-between items-start mb-4">
                    <h2 class="text-2xl font-bold text-indigo-700"><?php echo htmlspecialchars($notice['title']); ?></h2>
                    <span class="text-sm text-gray-500"><?php echo date('F d, Y', strtotime($notice['created_at'])); ?></span>
                </div>

                <?php if ($notice['image_url']): ?>
                    <img src="<?php echo htmlspecialchars($notice['image_url']); ?>" alt="Notice Image" class="rounded-lg w-full max-h-96 object-cover mb-4">
                <?php endif; ?>

                <div class="text-gray-700 whitespace-pre-wrap">
                    <?php echo nl2br(htmlspecialchars($notice['description'])); ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="bg-blue-100 p-6 rounded-xl shadow-lg text-blue-800">
            <p>There are currently no notices or announcements.</p>
        </div>
    <?php endif; ?>
</div>

<?php render_main_content_end(); ?>