<?php
require_once 'config.php';
require_login();

if (is_admin()) {
    header('Location: dashboard.php'); // Redirect admins
    exit();
}

// Fetch Student Stats
$studentId = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT COUNT(sp.pack_id) as total_packs FROM student_packs sp WHERE sp.student_id = ?");
$stmt->execute([$studentId]);
$totalPacks = $stmt->fetchColumn();

// Fetch Latest Notices
$stmt = $pdo->prepare("SELECT title, description, created_at FROM notices ORDER BY created_at DESC LIMIT 3");
$stmt->execute();
$notices = $stmt->fetchAll();

require_once 'layouts.php';
render_header('Student Dashboard');
render_sidebar($_SESSION['user_role'], basename(__FILE__));
render_topbar('Welcome back, ' . htmlspecialchars($_SESSION['user_name']) . '!');
?>

<div class="space-y-8">
    <!-- Key Stats -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="bg-white p-6 rounded-xl shadow-lg border-l-4 border-indigo-500">
            <h2 class="text-sm font-medium text-gray-500">Total Lesson Packs</h2>
            <p class="text-3xl font-bold text-gray-900 mt-1"><?php echo $totalPacks; ?></p>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg border-l-4 border-green-500">
            <h2 class="text-sm font-medium text-gray-500">A/L Year</h2>
            <p class="text-3xl font-bold text-gray-900 mt-1">
                <?php
                $stmt = $pdo->prepare("SELECT a_l_year FROM users WHERE id = ?");
                $stmt->execute([$studentId]);
                echo htmlspecialchars($stmt->fetchColumn() ?: 'N/A');
                ?>
            </p>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg border-l-4 border-red-500">
            <h2 class="text-sm font-medium text-gray-500">Pending Slips</h2>
            <?php
            $stmt = $pdo->prepare("SELECT COUNT(id) FROM slips WHERE student_id = ? AND status = 'pending'");
            $stmt->execute([$studentId]);
            $pendingSlips = $stmt->fetchColumn();
            ?>
            <p class="text-3xl font-bold text-gray-900 mt-1"><?php echo $pendingSlips; ?></p>
        </div>
    </div>

    <!-- Notices Summary -->
    <div class="bg-white p-6 rounded-xl shadow-lg">
        <h2 class="text-2xl font-semibold text-gray-900 mb-4">Latest Notices</h2>
        <?php if ($notices): ?>
            <ul class="divide-y divide-gray-200">
                <?php foreach ($notices as $notice): ?>
                    <li class="py-3">
                        <p class="text-lg font-medium text-indigo-600"><?php echo htmlspecialchars($notice['title']); ?></p>
                        <p class="text-sm text-gray-600 truncate"><?php echo htmlspecialchars($notice['description']); ?></p>
                        <span class="text-xs text-gray-400"><?php echo date('M d, Y', strtotime($notice['created_at'])); ?></span>
                    </li>
                <?php endforeach; ?>
            </ul>
            <div class="mt-4 text-right">
                <a href="notices.php" class="text-indigo-600 hover:text-indigo-800 font-medium">View All Notices &rarr;</a>
            </div>
        <?php else: ?>
            <p class="text-gray-500">No recent notices available.</p>
        <?php endif; ?>
    </div>
</div>

<?php render_main_content_end(); ?>