<?php
require_once 'config.php';
require_admin();

$message = $_GET['msg'] ?? '';

// --- CRUD Operations ---
if (isset($_POST['add_pack'])) {
    $title = trim($_POST['title']);
    $description = trim($_POST['description']);
    $price = (float)$_POST['price'];

    // Thumbnail upload logic (Basic implementation)
    $thumbnail_url = 'https://placehold.co/400x250/60a5fa/ffffff?text=' . urlencode($title);
    if (!empty($_FILES['thumbnail']['name']) && $_FILES['thumbnail']['error'] == UPLOAD_ERR_OK) {
        $uploadDir = 'uploads/packs/';
        if (!is_dir($uploadDir)) { mkdir($uploadDir, 0777, true); }
        $fileName = uniqid('pack_') . '_' . basename($_FILES['thumbnail']['name']);
        $targetPath = $uploadDir . $fileName;
        if (move_uploaded_file($_FILES['thumbnail']['tmp_name'], $targetPath)) {
            $thumbnail_url = $targetPath;
        } else {
            $message = 'Warning: Failed to upload thumbnail image. Using placeholder.';
        }
    }

    try {
        $stmt = $pdo->prepare("INSERT INTO lesson_packs (title, description, thumbnail_url, price) VALUES (?, ?, ?, ?)");
        $stmt->execute([$title, $description, $thumbnail_url, $price]);
        $message = 'Lesson Pack added successfully!';
    } catch (PDOException $e) {
        $message = 'Error adding pack: ' . $e->getMessage();
    }
}

if (isset($_POST['delete_pack'])) {
    $packId = $_POST['pack_id'];
    try {
        $stmt = $pdo->prepare("DELETE FROM lesson_packs WHERE id = ?");
        $stmt->execute([$packId]);
        $message = 'Lesson Pack deleted successfully.';
    } catch (PDOException $e) {
        $message = 'Error deleting pack: ' . $e->getMessage();
    }
}

// --- Fetch All Lesson Packs with Counts ---
$stmt = $pdo->query("
    SELECT
        lp.id,
        lp.title,
        lp.thumbnail_url,
        lp.price,
        COUNT(DISTINCT l.id) AS num_lessons,
        COUNT(DISTINCT sp.student_id) AS assigned_student_count
    FROM lesson_packs lp
    LEFT JOIN lessons l ON lp.id = l.pack_id
    LEFT JOIN student_packs sp ON lp.id = sp.pack_id
    GROUP BY lp.id
    ORDER BY lp.id DESC
");
$packs = $stmt->fetchAll();

require_once 'layouts.php';
render_header('Lesson Pack Management');
render_sidebar($_SESSION['user_role'], basename(__FILE__));
render_topbar('Lesson Pack Management');
?>

<div class="space-y-8">
    <?php if ($message): ?>
        <div class="bg-indigo-100 border-l-4 border-indigo-500 text-indigo-700 p-4 mb-6 rounded-lg" role="alert"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <!-- Add New Pack Form -->
    <div class="bg-white p-6 rounded-xl shadow-lg">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">Add New Lesson Pack</h2>
        <form method="POST" action="addpack.php" enctype="multipart/form-data" class="space-y-4">
            <div>
                <label for="title" class="block text-sm font-medium text-gray-700">Title</label>
                <input type="text" name="title" id="title" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg">
            </div>
            <div>
                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                <textarea name="description" id="description" rows="3" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg"></textarea>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="thumbnail" class="block text-sm font-medium text-gray-700">Thumbnail</label>
                    <input type="file" name="thumbnail" id="thumbnail" accept="image/*" class="mt-1 block w-full text-sm text-gray-900 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                </div>
                <div>
                    <label for="price" class="block text-sm font-medium text-gray-700">Price (Rs.)</label>
                    <input type="number" name="price" id="price" step="0.01" min="0" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg">
                </div>
            </div>
            <button type="submit" name="add_pack" class="w-48 py-3 bg-green-600 text-white rounded-lg hover:bg-green-700 font-semibold transition duration-150 shadow-md">
                Create Lesson Pack
            </button>
        </form>
    </div>

    <!-- All Lesson Packs List -->
    <h2 class="text-2xl font-bold text-gray-900 pt-4 border-t mt-8">All Lesson Packs (<?php echo count($packs); ?>)</h2>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php if ($packs): ?>
            <?php foreach ($packs as $pack): ?>
                <div class="bg-white rounded-xl overflow-hidden shadow-lg border-b-4 border-indigo-400">
                    <img src="<?php echo htmlspecialchars($pack['thumbnail_url']); ?>" alt="<?php echo htmlspecialchars($pack['title']); ?>" class="w-full h-40 object-cover">
                    <div class="p-4">
                        <h3 class="text-xl font-bold text-gray-900 line-clamp-1"><?php echo htmlspecialchars($pack['title']); ?></h3>
                        <p class="text-2xl font-extrabold text-green-600 mb-3">Rs. <?php echo number_format($pack['price'], 2); ?></p>

                        <div class="flex justify-between text-sm text-gray-600 mb-4">
                            <span><i class="fa-solid fa-video mr-1"></i> Lessons: <span class="font-semibold text-gray-800"><?php echo $pack['num_lessons']; ?></span></span>
                            <span><i class="fa-solid fa-users mr-1"></i> Students: <span class="font-semibold text-gray-800"><?php echo $pack['assigned_student_count']; ?></span></span>
                        </div>

                        <div class="flex space-x-2">
                            <a href="addclass.php?pack_id=<?php echo $pack['id']; ?>" class="flex-1 py-2 bg-indigo-500 text-white rounded-lg text-center hover:bg-indigo-600 text-sm font-semibold">
                                <i class="fa-solid fa-plus mr-1"></i> Add Lesson
                            </a>
                            <button onclick="confirmDeletePack(<?php echo $pack['id']; ?>, '<?php echo htmlspecialchars(addslashes($pack['title'])); ?>')"
                                    class="py-2 px-4 bg-red-500 text-white rounded-lg hover:bg-red-600 text-sm font-semibold">
                                <i class="fa-solid fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="md:col-span-3 text-gray-500">No lesson packs created yet.</p>
        <?php endif; ?>
    </div>
</div>

<!-- Simple Delete Confirmation Modal (not a pop-up alert) -->
<div id="delete-modal" class="fixed inset-0 bg-gray-900 bg-opacity-75 hidden items-center justify-center p-4 z-50">
    <div class="bg-white rounded-xl shadow-2xl max-w-sm w-full p-6 text-center">
        <i class="fa-solid fa-exclamation-triangle text-5xl text-red-500 mb-4"></i>
        <h3 class="text-xl font-bold text-gray-900 mb-2">Confirm Deletion</h3>
        <p class="text-gray-600 mb-6">Are you sure you want to delete the lesson pack: <span id="pack-title-to-delete" class="font-semibold"></span>? This action is permanent and will remove all associated lessons.</p>
        <form method="POST" action="addpack.php" class="flex justify-center space-x-4">
            <input type="hidden" name="pack_id" id="delete-pack-id">
            <button type="button" onclick="document.getElementById('delete-modal').classList.add('hidden')" class="px-5 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400 font-semibold transition">Cancel</button>
            <button type="submit" name="delete_pack" class="px-5 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 font-semibold transition">Delete</button>
        </form>
    </div>
</div>

<script>
    function confirmDeletePack(packId, packTitle) {
        document.getElementById('delete-pack-id').value = packId;
        document.getElementById('pack-title-to-delete').textContent = packTitle;
        document.getElementById('delete-modal').classList.remove('hidden');
        document.getElementById('delete-modal').classList.add('flex');
    }
</script>

<?php render_main_content_end(); ?>