<?php
require_once 'config.php';

$message = $_GET['msg'] ?? '';

// Handle Logout
if (isset($_GET['logout'])) {
    session_destroy();
    session_start();
    $message = 'You have been successfully logged out.';
}

// Handle Login
if (isset($_POST['login'])) {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        // Successful Login
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_name'] = $user['name'];
        $_SESSION['user_role'] = $user['role'];
        $_SESSION['image_url'] = $user['image_url'];

        // Redirect based on role
        if ($user['role'] === 'admin') {
            header('Location: dashboard.php');
        } else {
            header('Location: studentdash.php');
        }
        exit();
    } else {
        $message = 'Invalid email or password.';
    }
}

// Handle Registration
if (isset($_POST['register'])) {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $a_l_year = trim($_POST['a_l_year']);

    if (empty($name) || empty($email) || empty($password)) {
        $message = 'All fields are required for registration.';
    } else {
        try {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO users (name, email, password, a_l_year, role) VALUES (?, ?, ?, ?, 'student')");
            $stmt->execute([$name, $email, $hashed_password, $a_l_year]);

            // Log registration event
            log_analytics($pdo, 'registration', $pdo->lastInsertId());

            $message = 'Registration successful! Please login.';
        } catch (PDOException $e) {
            if ($e->getCode() === '23000') {
                $message = 'Registration failed: This email is already registered.';
            } else {
                $message = 'Registration failed due to a database error.';
            }
        }
    }
}

require_once 'layouts.php';
render_header('Login/Register');
?>

<div class="min-h-screen flex items-center justify-center bg-gray-100">
    <script>
        // Toggle between Login and Register forms
        function toggleForm(showForm) {
            document.getElementById('login-form').classList.add('hidden');
            document.getElementById('register-form').classList.add('hidden');
            document.getElementById(showForm + '-form').classList.remove('hidden');
            document.getElementById('login-tab').classList.remove('bg-indigo-600', 'text-white');
            document.getElementById('register-tab').classList.remove('bg-indigo-600', 'text-white');
            document.getElementById(showForm + '-tab').classList.add('bg-indigo-600', 'text-white');
        }
    </script>
    <div class="max-w-md w-full bg-white p-8 rounded-xl shadow-2xl">
        <h1 class="text-4xl font-extrabold text-center text-gray-900 mb-6"><?php echo APP_NAME; ?></h1>

        <!-- Messages -->
        <?php if ($message): ?>
            <div class="bg-indigo-100 border-l-4 border-indigo-500 text-indigo-700 p-4 mb-4 rounded-lg" role="alert">
                <p><?php echo htmlspecialchars($message); ?></p>
            </div>
        <?php endif; ?>

        <!-- Tabs -->
        <div class="flex mb-6 bg-gray-200 rounded-lg p-1">
            <button id="login-tab" onclick="toggleForm('login')" class="flex-1 py-2 px-4 rounded-lg font-semibold transition duration-150 bg-indigo-600 text-white">Login</button>
            <button id="register-tab" onclick="toggleForm('register')" class="flex-1 py-2 px-4 rounded-lg font-semibold transition duration-150 text-gray-600">Register</button>
        </div>

        <!-- Login Form -->
        <form id="login-form" method="POST" action="index.php" class="space-y-6">
            <div>
                <label for="login_email" class="block text-sm font-medium text-gray-700">Email Address</label>
                <input id="login_email" name="email" type="email" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
            </div>
            <div>
                <label for="login_password" class="block text-sm font-medium text-gray-700">Password</label>
                <input id="login_password" name="password" type="password" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
            </div>
            <button type="submit" name="login" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-lg shadow-sm text-lg font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition duration-150">
                Sign in
            </button>
        </form>

        <!-- Register Form -->
        <form id="register-form" method="POST" action="index.php" class="space-y-6 hidden">
            <div>
                <label for="reg_name" class="block text-sm font-medium text-gray-700">Full Name</label>
                <input id="reg_name" name="name" type="text" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
            </div>
            <div>
                <label for="reg_email" class="block text-sm font-medium text-gray-700">Email Address</label>
                <input id="reg_email" name="email" type="email" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
            </div>
            <div>
                <label for="reg_password" class="block text-sm font-medium text-gray-700">Password</label>
                <input id="reg_password" name="password" type="password" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
            </div>
            <div>
                <label for="reg_year" class="block text-sm font-medium text-gray-700">A/L Year</label>
                <input id="reg_year" name="a_l_year" type="text" placeholder="e.g., 2027 A/L" required class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
            </div>
            <button type="submit" name="register" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-lg shadow-sm text-lg font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition duration-150">
                Register
            </button>
        </form>
    </div>
</div>

<?php render_footer(); ?>