<?php
require_once 'config.php';
require_admin();

$message = $_GET['msg'] ?? '';
$searchQuery = $_GET['search'] ?? '';
$newPassword = null;

// --- Handle Password Reset ---
if (isset($_POST['reset_password'])) {
    $studentId = (int)$_POST['student_id'];
    $newPassword = generate_random_password(8); // Generate random password
    $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

    try {
        // 1. Update password and store plain text version in 'new_password' for temporary display
        $stmt = $pdo->prepare("UPDATE users SET password = ?, new_password = ? WHERE id = ? AND role = 'student'");
        $stmt->execute([$hashedPassword, $newPassword, $studentId]);
        $message = 'Password reset successful.';
    } catch (PDOException $e) {
        $message = 'Error resetting password: ' . $e->getMessage();
    }
}

// --- Handle Student Removal ---
if (isset($_POST['remove_student'])) {
    $studentId = (int)$_POST['student_id'];
    try {
        $stmt = $pdo->prepare("DELETE FROM users WHERE id = ? AND role = 'student'");
        $stmt->execute([$studentId]);
        $message = 'Student successfully removed.';
    } catch (PDOException $e) {
        $message = 'Error removing student: ' . $e->getMessage();
    }
}

// --- Fetch Students (with optional search) ---
$sql = "SELECT id, name, email, a_l_year, new_password FROM users WHERE role = 'student'";
$params = [];

if (!empty($searchQuery)) {
    $sql .= " AND (name LIKE ? OR email LIKE ?)";
    $searchParam = "%" . $searchQuery . "%";
    $params = [$searchParam, $searchParam];
}
$sql .= " ORDER BY id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$students = $stmt->fetchAll();

require_once 'layouts.php';
render_header('User Management');
render_sidebar($_SESSION['user_role'], basename(__FILE__));
render_topbar('Student Management');
?>

<div class="space-y-8">
    <?php if ($message): ?>
        <div class="bg-indigo-100 border-l-4 border-indigo-500 text-indigo-700 p-4 mb-6 rounded-lg" role="alert"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <!-- Search Bar -->
    <div class="bg-white p-6 rounded-xl shadow-lg flex items-center space-x-4">
        <form method="GET" action="usermanage.php" class="flex w-full space-x-4">
            <input type="text" name="search" placeholder="Search by name or email..." value="<?php echo htmlspecialchars($searchQuery); ?>"
                   class="flex-grow px-4 py-2 border border-gray-300 rounded-lg focus:ring-indigo-500 focus:border-indigo-500">
            <button type="submit" class="px-5 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 font-semibold">
                <i class="fa-solid fa-search"></i> Search
            </button>
            <?php if ($searchQuery): ?>
                <a href="usermanage.php" class="px-5 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400 font-semibold">Clear</a>
            <?php endif; ?>
        </form>
    </div>

    <!-- Students Table -->
    <h2 class="text-2xl font-bold text-gray-900 pt-4 border-t mt-8">Registered Students (<?php echo count($students); ?>)</h2>
    <div class="bg-white rounded-xl shadow-lg overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">A/L Year</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php if ($students): ?>
                    <?php foreach ($students as $student): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">CM<?php echo htmlspecialchars($student['id'] + 100000); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo htmlspecialchars($student['name']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($student['email']); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($student['a_l_year'] ?? 'N/A'); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <form method="POST" action="usermanage.php" class="inline-block" onsubmit="return confirm('Are you sure you want to remove this student?');">
                                    <input type="hidden" name="student_id" value="<?php echo $student['id']; ?>">
                                    <button type="submit" name="remove_student" class="text-red-600 hover:text-red-900 mr-4">Remove</button>
                                </form>
                                <button onclick="openPasswordResetModal(<?php echo $student['id']; ?>, '<?php echo htmlspecialchars(addslashes($student['name'])); ?>')" class="text-indigo-600 hover:text-indigo-900">
                                    Reset Password
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="5" class="px-6 py-4 text-center text-gray-500">No students found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Password Reset Confirmation Modal -->
<div id="password-reset-modal" class="fixed inset-0 bg-gray-900 bg-opacity-75 hidden items-center justify-center p-4 z-50">
    <div class="bg-white rounded-xl shadow-2xl max-w-sm w-full p-6 text-center">
        <i class="fa-solid fa-key text-5xl text-indigo-500 mb-4"></i>
        <h3 class="text-xl font-bold text-gray-900 mb-2">Confirm Password Reset</h3>
        <p class="text-gray-600 mb-6">Are you sure you want to reset the password for <span id="student-name-reset" class="font-semibold"></span>?</p>
        <form method="POST" action="usermanage.php" class="flex justify-center space-x-4">
            <input type="hidden" name="student_id" id="reset-student-id">
            <button type="button" onclick="document.getElementById('password-reset-modal').classList.add('hidden')" class="px-5 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400 font-semibold transition">Cancel</button>
            <button type="submit" name="reset_password" class="px-5 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 font-semibold transition">Reset & Show</button>
        </form>
    </div>
</div>

<!-- New Password Display Modal (Pop-up) -->
<div id="new-password-modal" class="fixed inset-0 bg-gray-900 bg-opacity-75 hidden items-center justify-center p-4 z-50">
    <div class="bg-white rounded-xl shadow-2xl max-w-lg w-full p-8 text-center">
        <i class="fa-solid fa-lock text-5xl text-green-500 mb-4"></i>
        <h3 class="text-2xl font-bold text-gray-900 mb-2">New Password Generated!</h3>
        <p class="text-gray-600 mb-4">The new password for the student is (share this carefully):</p>
        <div class="bg-gray-100 p-4 rounded-lg border-2 border-dashed border-gray-300 mb-6">
            <code id="new-password-display" class="text-2xl font-mono text-indigo-700 select-all"></code>
        </div>
        <button onclick="document.getElementById('new-password-modal').classList.add('hidden');" class="px-6 py-3 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 font-semibold transition duration-150">
            Acknowledge
        </button>
    </div>
</div>

<script>
    function openPasswordResetModal(studentId, studentName) {
        document.getElementById('reset-student-id').value = studentId;
        document.getElementById('student-name-reset').textContent = studentName;
        document.getElementById('password-reset-modal').classList.remove('hidden');
        document.getElementById('password-reset-modal').classList.add('flex');
    }

    <?php if ($newPassword): // Automatically open the display modal if a password was reset ?>
        document.addEventListener('DOMContentLoaded', () => {
            const newPassModal = document.getElementById('new-password-modal');
            const newPassDisplay = document.getElementById('new-password-display');
            newPassDisplay.textContent = '<?php echo htmlspecialchars($newPassword); ?>';
            newPassModal.classList.remove('hidden');
            newPassModal.classList.add('flex');

            // Clear the temporary password in DB (optional, but good security practice)
            // This would require an AJAX call or a redirect to clear the field.
        });
    <?php endif; ?>
</script>

<?php render_main_content_end(); ?>