<?php
require_once 'config.php';
require_login();

if (is_admin()) {
    header('Location: dashboard.php');
    exit();
}

// Fetch all notices
$stmt = $pdo->prepare("SELECT title, description, image_url, created_at FROM notices ORDER BY created_at DESC");
$stmt->execute();
$notices = $stmt->fetchAll();

require_once 'layouts.php';
render_header('Notices');
render_sidebar($_SESSION['user_role'], basename(__FILE__));

// --- MODIFIED: Added GIF and changed Top Bar Title to 'Top Notices Page' ---
$topbar_content = '
    <div class="flex items-center space-x-3">
        <img src="assets/class.gif" alt="Announcement Icon" class="w-7 h-7 rounded-full shadow-md" />
        <h1 class="text-xl font-extrabold text-gray-900 leading-none">Top Notices Page</h1>
    </div>
';
render_topbar($topbar_content);
// -------------------------------------------------------------------------
?>
        <!-- SCENARIO A: Show all Lesson Pack Cards -->
        <div class="flex items-center mb-6">
            <img src="notice.gif" alt="Classes Icon" class="w-8 h-8 mr-3" />
            <h2 class="text-2xl font-extrabold text-gray-900">Notices</h2>
        </div>
<!-- Enhanced Grid and Card Layout for Notices (Modern Style) -->
<div class="p-4 sm:p-6 lg:p-8">
    <?php if ($notices): ?>
        <!-- Adjusted Grid: Max 2 columns for wider, more impactful cards -->
        <div class="grid gap-8 sm:grid-cols-1 md:grid-cols-2 lg:grid-cols-2 xl:grid-cols-2">
            <?php foreach ($notices as $notice): ?>
                <!-- Notice Card START -->
                <div class="bg-white rounded-3xl shadow-2xl overflow-hidden transform hover:shadow-indigo-500/50 hover:scale-[1.01] transition duration-500 ease-in-out">
                    
                    <!-- Top Meta/Action Bar (Mimicking the style near the title in the image) -->
                    <div class="px-6 pt-5 pb-3 flex justify-between items-center border-b border-gray-100 bg-gray-50">
                        <span class="text-sm font-medium text-gray-500">
                            Posted: <?php echo date('M d, Y', strtotime($notice['created_at'])); ?>
                        </span>
                        <!-- Placeholder for modern action icon (like the send icon in the image) -->
                        <button class="text-indigo-600 hover:text-indigo-800 transition duration-150 p-1 rounded-full hover:bg-indigo-100" title="Share Notice">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                            </svg>
                        </button>
                    </div>

                    <!-- Image Section (Prominent and Fixed height) -->
                    <?php if ($notice['image_url']): ?>
                        <div class="h-80 overflow-hidden">
                            <img src="<?php echo htmlspecialchars($notice['image_url']); ?>" alt="Notice Image" 
                                 class="w-full h-full object-cover" 
                                 onerror="this.onerror=null;this.src='https://placehold.co/800x400/F3F4F6/6B7280?text=Notice+Image';"
                            >
                        </div>
                    <?php endif; ?>

                    <!-- Content Section -->
                    <div class="p-6">
                        <h2 class="text-2xl font-bold text-indigo-700 mb-4 leading-snug">
                            <?php echo htmlspecialchars($notice['title']); ?>
                        </h2>
                        
                        <!-- Description Area -->
                        <div class="text-gray-700 text-base leading-relaxed whitespace-pre-wrap">
                            <?php 
                                // Keep original nl2br and htmlspecialchars logic
                                echo nl2br(htmlspecialchars($notice['description'])); 
                            ?>
                        </div>
                    </div>
                </div>
                <!-- Notice Card END -->
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <!-- Styled 'No Notices' Message -->
        <div class="flex flex-col items-center justify-center p-12 bg-indigo-50 rounded-2xl shadow-inner border-2 border-indigo-300 text-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-indigo-600 mb-4 animate-pulse" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
            </svg>
            <p class="text-2xl font-bold text-indigo-900">No New Announcements Yet</p>
            <p class="text-indigo-700 mt-2">We'll notify you as soon as new information is published.</p>
        </div>
    <?php endif; ?>
</div>

<?php render_main_content_end(); ?>